<?php

namespace Tests\Feature;

use App\Models\Product;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class ProductManagementTest extends TestCase
{
    use RefreshDatabase;

    public function test_admin_can_create_a_product()
    {
        $admin = User::factory()->create(['is_admin' => true]);

        $this->actingAs($admin);

        $response = $this->post('/products', [
            'name' => 'Test Product',
            'description' => 'Test Description',
            'sku' => 'TEST123',
            'status' => 'active',
            'category_id' => null,
            'brand_id' => null,
        ]);

        $response->assertRedirect('/products');
        $this->assertDatabaseHas('products', ['name' => 'Test Product']);
    }

    public function test_admin_can_update_a_product()
    {
        $admin = User::factory()->create(['is_admin' => true]);
        $product = Product::factory()->create();

        $this->actingAs($admin);

        $response = $this->patch("/products/{$product->id}", [
            'name' => 'Updated Product',
            'description' => 'Updated Description',
            'sku' => 'UPDATED123',
            'status' => 'active',
        ]);

        $response->assertRedirect('/products');
        $this->assertDatabaseHas('products', ['name' => 'Updated Product']);
    }

    public function test_admin_can_delete_a_product()
    {
        $admin = User::factory()->create(['is_admin' => true]);
        $product = Product::factory()->create();

        $this->actingAs($admin);

        $response = $this->delete("/products/{$product->id}");

        $response->assertRedirect('/products');
        $this->assertSoftDeleted($product);
    }
}